/**
 * 
 */
package gov.va.med.mhv.phr.wellnessreminders.portlet;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.beehive.netui.pageflow.Forward;
import org.apache.beehive.netui.pageflow.annotations.Jpf;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.properties.SortOrderEnum;
import org.tigris.atlas.messages.DefaultMessage;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.MessageUtils;
import org.tigris.atlas.messages.Messages;
import org.tigris.atlas.service.EntityCollectionServiceResponse;

import gov.va.med.mhv.core.util.MessagesStringBuilder;
import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.phr.wellnessreminders.decorator.WellnessReminderDecorator;
import gov.va.med.mhv.phr.wellnessreminders.decorator.WellnessReminderTableDecorator;
import gov.va.med.mhv.phr.wellnessreminders.model.WellnessReminderRowSorter;
import gov.va.med.mhv.phr.decorator.DecoratorUtils;
import gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController;
import gov.va.med.mhv.phr.service.WellnessPreferenceCollectionServiceResponse;
import gov.va.med.mhv.phr.service.WellnessPreferenceServiceResponse;
import gov.va.med.mhv.phr.service.WellnessReminderCollectionServiceResponse;
import gov.va.med.mhv.phr.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.phr.service.delegate.WellnessPreferenceBusinessServiceDelegate;
import gov.va.med.mhv.phr.service.FacilityControlServiceResponse;
import gov.va.med.mhv.phr.service.delegate.EntityMaintenanceServiceDelegate;
import gov.va.med.mhv.phr.transfer.FacilityControl;
import gov.va.med.mhv.phr.transfer.ImpreciseDateComposite;
import gov.va.med.mhv.phr.transfer.WellnessPreference;
import gov.va.med.mhv.phr.transfer.WellnessReminder;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ExtractType;
import gov.va.med.mhv.usermgmt.service.FacilityInfoServiceResponse;
import gov.va.med.mhv.usermgmt.service.delegate.ActivityAuditServiceDelegate;
import gov.va.med.mhv.usermgmt.transfer.Activity;
import gov.va.med.mhv.usermgmt.transfer.Facility;
import gov.va.med.mhv.usermgmt.transfer.FacilityInfo;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.phr.transfer.TransferObjectFactory;


/*
 * This class is the Page Flow Controller for the Wellness reminder extract
 * @author                   
 */
@Jpf.Controller(strutsMerge = "/WEB-INF/struts-override.xml")
public class WellnessReminderPageFlowController extends ExtractPageFlowBaseController {

     private static final long serialVersionUID = 2066922212L;

     private static final Log LOG = LogFactory.getLog(
    		 WellnessReminderPageFlowController.class);
     
     private static final String ENTITY_NAME = StringUtils.substringAfterLast(
       WellnessReminder.class.getName(), "."); 
     
     private static final String HELP_PREFIX = "PHR_WellnessReminders_";

     private static final String TABLE_UID = "WellnessReminder";
     
     private static final String TABLE_SESSION_KEY = 
         "gov.va.med.mhv.phr.wellnessreminders";

     private static final String SHOW_RESOLVED_WELLNESS_REMINDERS = "showResolvedWellnessReminders";

     private static final ExtractType EXTRACT_TYPE = ExtractType.getEnum(
         ExtractType.WELLNESSREMINDERS);

     private WellnessReminderDecorator currentWellnessReminder = null;
     private transient EntityMaintenanceServiceDelegate entityMaintenanceServiceDelegate = gov.va.med.mhv.phr.service.delegate.ServiceDelegateFactory.createEntityMaintenanceServiceDelegate();
      
     
     private String preferenceMessageSymbol;
     private List availableFacilities = new ArrayList();
     private String[] selectedFacilities;
     private String message = " ";
     private boolean pastDueMessage = false;
     private List pastDueMessagesList = new ArrayList();
     private String fromPage;
     private static final String RESOLVED = "Resolved";
     private static final String UNRESOLVED = "Unresolved";
     private static final String DUE_NOW = "DUE NOW";
     private static final String PAST_DUE = "PAST DUE";
     private String fromPageParameterName = "fromPage";
     private Messages messages;
     

     @Jpf.Action(forwards = {
         @Jpf.Forward(name = "success", path = "wellnessReminderUnresolvedSummary.jsp"),
         @Jpf.Forward(name = "patient-not-ipa-ed", 
             path="notInPersonAuthenticated.jsp"),
         @Jpf.Forward(name = "patient-not-correlated", 
             path="../../common/notPatientCorrelated.jsp"),
         @Jpf.Forward(name = "failure", path = "wellnessReminderUnresolvedSummary.jsp")
     })
     @Override
     public Forward begin() {
	      Forward response = super.begin();
	      this.currentWellnessReminder = null;
	      setFromPage(UNRESOLVED);
	      return response;         
     }

     /*
      * Method execute when refresh button is pressed
      *   (non-Javadoc)
      * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#refresh()
      */
     @Jpf.Action(
         forwards = { @Jpf.Forward(name = "success", action = "begin") }
     )
     public Forward refresh() {
         Forward forward = new Forward("success");
         return forward;
     }

     /*
      * Callback that is invoked when this controller instance is created.
      */
     @Override
     protected void onCreate() {
     }

     /* (non-Javadoc)
      * @see gov.va.med.mhv.beehive.EntityPagingListPageFlowController#
      * getTableUID()
      */
     @Override
     public String getTableUID() {
         return TABLE_UID;
     }

     /* (non-Javadoc)
      * @see gov.va.med.mhv.beehive.EntityPagingListPageFlowController#
      * getDefaultSortProperty()
      */
     @Override
     public Integer getDefaultSortProperty() {
         return 2;
     }

     /* (non-Javadoc)
      * @see gov.va.med.mhv.beehive.EntityPagingListPageFlowController#
      * getDefaultSortOrder()
      */
     @Override
     public SortOrderEnum getDefaultSortOrder() {
         return SortOrderEnum.DESCENDING;
     }

     /*
      * This method returns the name of the custom row sorting class for
      * appointments.
      * 
      * @return a String containing the name of the custom sorter class
      */
     public String getSortClassName() {
         return WellnessReminderRowSorter.class.getName();
     }

     /*
      * This method returns the name of the Wellness reminder decorator class
      * 
      * @return a String contaning the name of the Wellness reminder decorator class
      */
     public String getDecoratorClassName() {
         return WellnessReminderTableDecorator.class.getName();
         //return WellnessReminderDecorator.class.getName();
     }

     /* (non-Javadoc)
      * @see org.tigris.atlas.beehive.EntityListMaintenancePageFlowController#
      * getTableSessionKey()
      */
     @Override
     protected String getTableSessionKey() {
         return TABLE_SESSION_KEY;
     }

     /* (non-Javadoc)
      * @see org.tigris.atlas.beehive.EntityMaintenancePageFlowController#
      * getTransferObjectClass()
      */
     @Override
     protected Class getTransferObjectClass() {
         return WellnessReminder.class;
     }

     /* (non-Javadoc)
      * @see org.tigris.atlas.beehive.EntityMaintenancePageFlowController#
      * getEntityName()
      */
     @Override
     protected String getEntityName() {
         return ENTITY_NAME;
     }

     /* (non-Javadoc)
      * @see org.tigris.atlas.beehive.AbstractPageFlowController#getFormClass()
      */
     @Override
     protected Class getFormClass() {
         return WellnessReminderPageFlowController.class;
     }

     /*
      * This method returns the current the current wellness reminder.
      * 
      * @return the WellnessReminderDecorator for the current wellness reminder
      */
     public WellnessReminderDecorator getCurrentWellnessReminder() {
         return currentWellnessReminder;
     }
     
     /*
      * Printer friendly method for resolved status wellness reminders summary 
      */
     @Jpf.Action(
         forwards = {@Jpf.Forward(name = "success", path = "wellnessReminderResolvedSummaryPF.jsp")}
     )
     public Forward viewPrinterFriendlyResolvedStatusSummary() {
         return determineForward();
     }

     /*
      * Printer friendly method for resolved status wellness reminder detail
      */
     @Jpf.Action(
         forwards = {@Jpf.Forward(name = "success", path = "wellnessReminderDetailPF.jsp"),
                     @Jpf.Forward(name = "failure", path = "wellnessReminderDetailPF.jsp")}     
     )
     public Forward viewPrinterFriendlyResolvedStatusDetails() {
         return determineForward();
     }
     
     /*
      * Printer friendly method for unresolved status wellness reminders summary 
      */
     @Jpf.Action(
         forwards = {@Jpf.Forward(name = "success", path = "wellnessReminderUnresolvedSummaryPF.jsp")}
     )
     public Forward viewPrinterFriendlyUnresolvedStatusSummary() {
         return determineForward();
     }

     /*
      * Printer friendly method for unresolved status wellness reminder detail
      */
     @Jpf.Action(
         forwards = {
        		 @Jpf.Forward(name = "success", path = "wellnessReminderDetailPF.jsp"),
                 @Jpf.Forward(name = "failure", path = "wellnessReminderDetailPF.jsp")}
     )
     public Forward viewPrinterFriendlyUnresolvedStatusDetails() {
    	 
  		String dueDateStr = currentWellnessReminder.getDueDate();
 		if (dueDateStr != null && (PAST_DUE.equals(dueDateStr) || DUE_NOW.equals(dueDateStr))) {
 			handleMessage(MessageUtils.createErrorMessage(
                    "phr.wellnessreminder.detail.pastDue.error", null, 
                    new Object[] { currentWellnessReminder.getSubject() }));
 		}    	 
    	 
         return determineForward();
     }
     
     

     /*
      *  (non-Javadoc)
      * @see org.tigris.atlas.beehive.EntityListMaintenancePageFlowController#returnToListAction()
      */
     @Jpf.Action(forwards = { 
         @Jpf.Forward(name = "success", path = "wellnessReminderResolvedSummary.jsp") 
     })
     @Override
     public Forward returnToListAction() {
         currentWellnessReminder = null;
         return super.returnToListAction();
     }
     
     /*
      * 
      */
     @Jpf.Action(forwards = { 
         @Jpf.Forward(name = "viewSummary", path = "wellnessReminderUnresolvedSummary.jsp") 
     })
     public Forward returnToUnresolvedSummaryAction() {
         return new Forward("viewSummary");
     }
     
     /*
      * 
      */
     @Jpf.Action(forwards = { 
         @Jpf.Forward(name = "viewSummary", path = "wellnessReminderResolvedSummary.jsp") 
     })
     public Forward returnToResolvedSummaryAction() {
         return new Forward("viewSummary");
     }     

     
     @Jpf.Action(forwards = {
         @Jpf.Forward(name = "viewDetails", path = "wellnessReminderDetail.jsp") 
     })
     public Forward returnToViewAction() {
    	 if(currentWellnessReminder != null){
    		 String dueDateStr = currentWellnessReminder.getDueDate();
      		if (dueDateStr != null && (PAST_DUE.equals(dueDateStr) || DUE_NOW.equals(dueDateStr))) {
     			handleMessage(MessageUtils.createErrorMessage(
                        "phr.wellnessreminder.detail.pastDue.error", null, 
                        new Object[] { currentWellnessReminder.getSubject() }));
     		}
    	 }
    	 return new Forward("viewDetails");
     }
     

	  @Jpf.Action(forwards = {
	          @Jpf.Forward(name = "success", path = "wellnessReminderPreferences.jsp"),
	          @Jpf.Forward(name = "failure", path = "wellnessReminderResolvedSummary.jsp") 
	      })
	  /**
	    * Loads the appropriate wellness reminder summary.
	    * @return Forward denoting the summary view 
	    */
	  public Forward viewPreferences(){

        Forward forward = null;
        this.setMessage("");
        setFromPage(getRequest().getParameter(getFromPageParameterName()));
        
        Set facilities = getPatient().getFacilitys();
        Precondition.assertNotEmpty("facilities", facilities);
        
        Iterator itr = facilities.iterator();
        availableFacilities = new ArrayList();
		while (itr.hasNext()) {
		     Facility facility = (Facility)itr.next();
			 if(facility.getFacilityInfo().getTreatment()){			     
			     FacilityInfo fi = facility.getFacilityInfo();
			     availableFacilities.add(fi.getName());
		     }
        }
        WellnessPreferenceCollectionServiceResponse prefResponse = ServiceDelegateFactory.createWellnessPreferenceBusinessServiceDelegate().getWellnessPreferencesByPatientId(getPatientId());
        Collection<WellnessPreference> wellnessPreferences = prefResponse.getWellnessPreferences();
        
        selectedFacilities = new String[wellnessPreferences.size()];
        int count = 0;
        
        for (WellnessPreference pref: wellnessPreferences){
        	selectedFacilities[count] = pref.getFacilityInfo().getName();
        	count++;
        }
        getSession().setAttribute("selectedWellnessPreferences", wellnessPreferences);
        
        forward = determineForward();
	    return forward;        
     }
	  
	  

	     @Jpf.Action(forwards = {
	             @Jpf.Forward(name = "resolved", path = "wellnessReminderResolvedSummary.jsp"),
	             @Jpf.Forward(name = "Unresolved", path = "wellnessReminderUnresolvedSummary.jsp")
	         })      
     /**
       * Saves the wellness reminder preferences.
       * @return Forward denoting the summary view
       */
     public Forward goToRemindersList() {
    	 Forward forward = null;
    	 
    	 String goToPage = getRequest().getParameter(getFromPageParameterName());
    	 setFromPage(getRequest().getParameter(getFromPageParameterName()));
    	 if((goToPage != null) && (goToPage.length() > 0)) {
    		 forward = new Forward (goToPage);
    	 }
    	 else{
    		 forward = new Forward ("resolved");
    	 }	    	 
    	 return forward;    	 
     }
	  
     
     @Jpf.Action(forwards = {
          @Jpf.Forward(name = "success", path = "wellnessReminderPreferences.jsp"),
          @Jpf.Forward(name = "failure", path = "wellnessReminderPreferences.jsp") 
      })      
  /**
    * Saves the wellness reminder preferences.
    * @return Forward denoting the summary view
    */
    public Forward savePreferences() {
        Forward forward = null;
        setFromPage(getRequest().getParameter(getFromPageParameterName()));
       
        String[] fac = getSelectedFacilities();
        if(fac != null && fac.length>0) {
         
         //delete existing preferences from database
         Collection<WellnessPreference> selectedPreferences = (Collection<WellnessPreference>)getSession().getAttribute("selectedWellnessPreferences");
         if(selectedPreferences != null && selectedPreferences.size() > 0){
        	 for (WellnessPreference selectedPref: selectedPreferences){
        		 WellnessPreferenceServiceResponse resp = entityMaintenanceServiceDelegate.delete(((WellnessPreference)selectedPref).getWellnessPreferencePK());
        		 if(resp.getMessages().hasErrorMessages() || resp.getMessages().hasInformationalMessages()){
        			 handleMessages(resp);
        		 }
        	 }
         
          //remove existing preferences from session
          getSession().removeAttribute("selectedWellnessPreferences");
         }
        
         Set facilities = getPatient().getFacilitys();
         Precondition.assertNotEmpty("facilities", facilities);       
         Iterator itr = getPatient().getFacilitys().iterator();  
       
         Map<String, Facility> obj = new HashMap<String, Facility>();
    
         while (itr.hasNext()) {
             Facility facility = (Facility)itr.next();
             FacilityInfo fi = facility.getFacilityInfo();
             obj.put(fi.getName(), facility);
         }
         
          //insert new selected preferences into database
          for(int i=0;i<fac.length;i++){
               Facility facility = obj.get(fac[i]);
               WellnessPreference pref = buildWellnessPreference(facility);
               WellnessPreferenceServiceResponse resp = entityMaintenanceServiceDelegate.save(pref);
               if(resp.getMessages().hasErrorMessages() || resp.getMessages().hasInformationalMessages()){
                   handleMessages(resp);
               }
          }

          handleMessage(MessageUtils.createInformationalMessage(
                "phr.wellnessreminder.preferences.updated", null,
                new Object[] { getExtractDescription() }));
        }
        else{
            handleMessage(MessageUtils.createErrorMessage(
                    "phr.wellnessreminder.preferences.update.error", null,
                    new Object[] { getExtractDescription() }));
            return new Forward("failure");
        }
 
        forward = determineForward();
        return forward;
     }
     
     
     private WellnessPreference buildWellnessPreference(Facility facility){
	      WellnessPreference localPreference = TransferObjectFactory.createWellnessPreference();
	      
	      localPreference.setPatient(getPatient());
	      localPreference.setFacilityInfo(facility.getFacilityInfo());
	
	      FacilityControlServiceResponse fcResponse = ServiceDelegateFactory.createControlServiceDelegate().findFacilityControl(facility);
	      FacilityControl fControl = fcResponse.getFacilityControl();
	      localPreference.setControl(fControl);
	    
	      return localPreference;
     }
     
     
     
     @Jpf.Action(forwards = {
          @Jpf.Forward(name = "success", path = "wellnessReminderResolvedSummary.jsp"),
          @Jpf.Forward(name = "failure", path = "wellnessReminderResolvedSummary.jsp") 
      })
  /**
    * Loads the appropriate wellness reminder summary.
    * @return Forward denoting the summary view 
    */
  public Forward viewCompletedStatusSummary() {
        Forward forward = null;
        setFromPage(RESOLVED);
        
        WellnessReminderCollectionServiceResponse svc = ServiceDelegateFactory.createWellnessReminderBusinessServiceDelegate().
                          getResolvedStatusWellnessReminderByPatientId(getPatientId());
        Collection completedWellnessReminders = svc.getWellnessReminders();
        
        LOG.info("Size of completedWellnessReminders in viewCompletedStatusSummary: " + completedWellnessReminders.size() 
             		+ " for the patient: " + getFullPatientName() + " whose patient id is: "
             		+ getPatientId());
        
        getSession().setAttribute(getTableSessionKey(), completedWellnessReminders);
        //set the session variable for resolved wellness reminders
        getRequest().getSession().setAttribute(SHOW_RESOLVED_WELLNESS_REMINDERS, "Y");

        forward = determineForward();
        return forward;
  }
     
     @Jpf.Action(forwards = {
          @Jpf.Forward(name = "success", path = "wellnessReminderUnresolvedSummary.jsp"),
          @Jpf.Forward(name = "failure", path = "wellnessReminderUnresolvedSummary.jsp")
      })
  /**
    * Loads the appropriate wellness reminder summary.
    * @return Forward denoting the summary view 
    */
  public Forward viewNonCompletedStatusSummary() {
        Forward forward = null;
        
        WellnessReminderCollectionServiceResponse svc = ServiceDelegateFactory.createWellnessReminderBusinessServiceDelegate().
                          getUnresolvedStatusWellnessReminderByPatientId(getPatientId());
        Collection nonCompletedWellnessReminders = svc.getWellnessReminders();
            
        LOG.info("Size of NonCompletedWellnessReminders in viewNonCompletedStatusSummary: " + nonCompletedWellnessReminders.size() 
            		+ "for the patient: " + getFullPatientName() + " whose patient id is: "
            		+ getPatientId()); 
        getSession().setAttribute(getTableSessionKey(), nonCompletedWellnessReminders);
             
        //set the session variable for un-resolved wellness reminders
        getRequest().getSession().setAttribute(SHOW_RESOLVED_WELLNESS_REMINDERS, "N");
        
        forward = determineForward();
        return forward;
   }
     
     
     @SuppressWarnings("unchecked")
     public Collection<WellnessReminderDecorator> getDecorators() {
      Collection<WellnessReminderDecorator> result = 
             (Collection<WellnessReminderDecorator>)getRequest().
             getAttribute("CompletedStatusWellnessReminderTableDecorators");
      if ( result == null ) {
       Collection<WellnessReminder> entities = getCompletedStatusWellnessReminders();
       result = new ArrayList<WellnessReminderDecorator>();
       if ( entities != null ) {
        for(WellnessReminder p : entities) {
         result.add(new WellnessReminderDecorator(p));
        } 
          }
       getRequest().setAttribute("CompletedStatusWellnessReminderTableDecorators", result);
      }
         return result;
     }     
     
     public Collection<WellnessReminder> getCompletedStatusWellnessReminders() {
      Collection<WellnessReminder> result = new ArrayList<WellnessReminder>();
      Collection entities = this.getEntities();
      if ( entities != null ) {
       for(Object o : entities) {
        result.add((WellnessReminder)o);
       }
      }
      return result;
     }
  
  
     public Collection getWellnessReminders() {
    	 Collection<WellnessReminderDecorator> result = (Collection<WellnessReminderDecorator>)getRequest().getAttribute("WellnessReminders");
    	 if ( result == null ) {
	    	 Collection<WellnessReminder> entities = getEntities();
	    	 result = new ArrayList<WellnessReminderDecorator>();
	    	 if ( entities != null ) {
		    	 for(WellnessReminder reminder : entities) {
		    		 result.add(new WellnessReminderDecorator(reminder));
		    	 }
	    	 }
	    	 getRequest().setAttribute("WellnessReminders", result);
    	 }
    	 return result;
     }
     
     
     
     @Jpf.Action(forwards = {
          @Jpf.Forward(name = "success", path = "wellnessReminderDetail.jsp"),
          @Jpf.Forward(name = "failure", path = "wellnessReminderDetail.jsp") 
      })
      /**
       * Loads the appropriate appointment details and forwards to the
       * associated details view page.
       * @return Forward denoting the details view 
       */
      public Forward viewDetails() {    	 
    	  setFromPage(getRequest().getParameter(getFromPageParameterName()));
          Forward forward = null;
          WellnessReminder wellnessReminder = getWellnessReminderByStatusById(getDetailsId());
          if (wellnessReminder != null) {
            currentWellnessReminder = new WellnessReminderDecorator(wellnessReminder);            
            
     		String dueDateStr = getWellnessReminderDueDateAsStr(wellnessReminder);
     		if (dueDateStr != null && (PAST_DUE.equals(dueDateStr) || DUE_NOW.equals(dueDateStr))) {
     			handleMessage(MessageUtils.createErrorMessage(
                        "phr.wellnessreminder.detail.pastDue.error", null, 
                        new Object[] { wellnessReminder.getSubject() }));
     		} 
            forward = determineForward();
          } else {
              forward = determineForwardOnUnknownEntity("view");
          }
          return forward;
      }     

     private Long getDetailsId() {
         final String requestID = getRequest().getParameter("id");
         Precondition.assertNotBlank("request.id", requestID);
         Long id = null;
         try {
             id = Long.parseLong(requestID);
         } catch (NumberFormatException e) {
             Precondition.fail("request.id", "a Long", requestID,
                 "Unable to determine id for selected wellness reminder.");
         }
         return id;
     }

     private WellnessReminder getWellnessReminderByStatusById(Long id) {
         Collection wellnessReminders = getDetailWellnessReminders();
         if (wellnessReminders != null) {
             for(Object a: wellnessReminders) {
              WellnessReminder wellnessReminder = (WellnessReminder) a;
                 if (id.equals(wellnessReminder.getId())) { 
                     return wellnessReminder;
                 }
             }
         }
         return null;
     }
     public Collection getDetailWellnessReminders() {
         Collection entities = getEntities();
         return (entities != null) ? entities : new ArrayList();
     }     

     @Jpf.Action(
         forwards = {@Jpf.Forward(name = "success", path = "wellnessReminderUnresolvedSummary.jsp")}
     )
     public Forward handleUnresolvedPagingAndSorting() {
         return super.handlePagingAndSorting();
     }
     
     @Jpf.Action(
         forwards = {@Jpf.Forward(name = "success", path = "wellnessReminderResolvedSummary.jsp")}
     )
     public Forward handleResolvedPagingAndSorting() {
         return super.handlePagingAndSorting();
     }
     
     
	/*
	 * Help files for Wellness Reminders
	 */
     public String getSummaryHelpURI() {
         return createHelpURI(HELP_PREFIX + "SummaryHelp.html");
     }
     
     public String getCompletedSummaryHelpURI() {
         return createHelpURI(HELP_PREFIX + "CompletedSummaryHelp.html");
     }     

     public String getDetailsHelpURI() {
         return createHelpURI(HELP_PREFIX + "DetailsHelp.html");
     }
     
     public String getPreferencesHelpURI() {
         return createHelpURI(HELP_PREFIX + "PreferencesHelp.html");
     }
     

     /* (non-Javadoc)
      * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
      * getExtractType()
      */
     @Override
     protected ExtractType getExtractType() {
         return EXTRACT_TYPE;
     }

     /* (non-Javadoc)
      * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
      * getExtractName()
      */
     @Override
     public String getExtractName() {
         return "Wellness Reminders";
     }

     /*
      * (non-Javadoc)
      * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
      * loadExtract()
      */
     
     @Override
     protected EntityCollectionServiceResponse loadExtract() {
      
         WellnessPreferenceCollectionServiceResponse prefResponse = ServiceDelegateFactory.createWellnessPreferenceBusinessServiceDelegate().getWellnessPreferencesByPatientId(getPatientId());
         Collection<WellnessPreference> wellnessPreferences = prefResponse.getWellnessPreferences();
         //messages = prefResponse.getMessages();
                  
         if(wellnessPreferences == null || wellnessPreferences.size() == 0) {
             Set facilities = getPatient().getFacilitys();
             Precondition.assertNotEmpty("facilities", facilities);              
             
             Iterator itr = facilities.iterator();           
             while (itr.hasNext()) {
            	 Facility facility = (Facility)itr.next();
            	 if(facility.getFacilityInfo().getTreatment()){
            		 WellnessPreference wpref = buildWellnessPreference(facility);       
            		 WellnessPreferenceServiceResponse response = entityMaintenanceServiceDelegate.save(wpref);        
             
            		 if (response.getMessages().hasErrorMessages()) {
            			 LOG.error("Not able to store facilities in Wellness Preference table::" +
            			 response.getMessages().getErrorMessages());
            			 MessagesStringBuilder builder = new MessagesStringBuilder();
            			 builder.append(response.getMessages(), Patient.class);
            			 LOG.error(builder.getErrorString());
            			 String infoString = builder.getInfoString();
            			 if (!StringUtils.isBlank(infoString)) {
            				 LOG.info(infoString);
            			 }
            			 throw new IllegalStateException(message);
            		 }
            	 }                         
             }
         }  
         
         WellnessReminderCollectionServiceResponse remindersResponse = ServiceDelegateFactory.createWellnessReminderBusinessServiceDelegate().getUnresolvedStatusWellnessReminderByPatientId(getPatientId());
         Collection<WellnessReminder> wellnessReminders = remindersResponse.getWellnessReminders();         

         
         if (wellnessReminders != null && wellnessReminders.size() > 0) {
        	 buildMessages(wellnessReminders);    
         }
         return remindersResponse;
     }


     /*
      * Method to build the messages list for PAST DUE and DUE NOW status 
      * Wellness Reminder records
      */
     private void buildMessages(Collection<WellnessReminder> wellnessReminders) {
    	 pastDueMessagesList = new ArrayList();
         for (WellnessReminder reminder : wellnessReminders) {
        	 String dueDateStr = getWellnessReminderDueDateAsStr(reminder);
        	 if (dueDateStr != null && (PAST_DUE.equals(dueDateStr) || DUE_NOW.equals(dueDateStr))) {
        		 pastDueMessagesList.add(reminder.getSubject());
        		 setPastDueMessage(true);
        	 }
         }
     }
     

     /*
      * Method to convert the Due Date as string
      */
     private String getWellnessReminderDueDateAsStr(WellnessReminder reminder){
         ImpreciseDateComposite dueDate = reminder.getDueDateComposite();
         
         if (dueDate == null ||
             	((dueDate.getImpreciseValue() == null && dueDate.getValue() == null) ||
                       	 ("".equals(dueDate.getImpreciseValue()) && ("".equals(dueDate.getValue()))))) {
             return DUE_NOW;
         } 
         else {
         	String value = DecoratorUtils.extractValue(dueDate);
             DateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
         	try{
         		Date obj = sdf.parse(value);
         		Date today = new Date();
         		if(today.after(obj)){
         			return PAST_DUE;
         		}
         		else{
         			return value;
         		}	
         	}
         	catch (ParseException pe){
         		return value;
         	}
         }    	
     }     

     /*
      * (non-Javadoc)
      * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
      * createExtractServiceResponse()
      */
     @Override
     protected EntityCollectionServiceResponse createExtractServiceResponse() {
         return new WellnessReminderCollectionServiceResponse();
     }

     /*
      *  (non-Javadoc)
      * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#showNotInPersonAuthenticated()
      */
     @Jpf.Action(forwards = {
         @Jpf.Forward(name = "success", 
             path="../../common/notInPersonAuthenticated.jsp")
     })
     @Override
     public Forward showNotInPersonAuthenticated() {
         return super.showNotInPersonAuthenticated();
     }

  @Override
  protected void auditView() {
	   ActivityAuditServiceDelegate auditDelegate =  
	   gov.va.med.mhv.usermgmt.service.delegate.
	          ServiceDelegateFactory.createActivityAuditServiceDelegate();
	   
	   Activity activity = 
	    gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory.createActivity();
	  
	   activity.setAction(ActivityActionTypeEnumeration
	        .getEnum(ActivityActionTypeEnumeration.VIEW));
	   activity.setActionType(ActivityTypeEnumeration.WELLNESSREMINDERS);
	   activity.setPerformerType(ActivityActorTypeEnumeration
	        .getEnum(ActivityActorTypeEnumeration.SELF));
	   activity.setSubjectId(getCurrentUserId());
	   activity.setCompletionTime(new java.sql.Timestamp(
	        java.util.Calendar.getInstance().getTimeInMillis()));
	   activity.setStatus(Boolean.TRUE);
	   
	   auditDelegate.audit(activity);
     }

	  public String[] getAvailableFacilities() {
		  return (String[])availableFacilities.toArray(new String[availableFacilities.size()]);
	  }
	
	  public String[] getSelectedFacilities() {
	   return selectedFacilities;
	  }
	
	  public void setSelectedFacilities(String[] selectedFacilities) {
	   this.selectedFacilities = selectedFacilities;
	  }
	
	  public String getMessage() {
	   return message;
	  }
	
	  public void setMessage(String message) {
	   this.message = message;
	  }
	  
	  public int getMesg(){
		  return message.length();
	  }
	
	  public String getFromPage() {
	   return fromPage;
	  }
	
	  public void setFromPage(String fromPage) {
	   this.fromPage = fromPage;
	  }
	  
	  public String getFromPageParameterName() {
	    return fromPageParameterName;
	  }

	  public String getPreferenceMessageSymbol() {
		return preferenceMessageSymbol;
	  }
	
	  public void setPreferenceMessageSymbol(String preferenceMessageSymbol) {
		this.preferenceMessageSymbol = preferenceMessageSymbol;
	  }

	  public Messages getMessages() {
		return messages;
	  }
	
	  public boolean isPastDueMessage() {
		return pastDueMessage;
	  }
	
	  public void setPastDueMessage(boolean pastDueMessage) {
		this.pastDueMessage = pastDueMessage;
	  }
	
	  public List getPastDueMessagesList() {
		return pastDueMessagesList;
	  }
	
	  public void setPastDueMessagesList(List pastDueMessagesList) {
		this.pastDueMessagesList = pastDueMessagesList;
	  }
  
 }
